﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="System.Globalization" %>
<%@ Import Namespace="System.Linq" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
    <HEAD>
        <title></title>
        <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
        <meta content="C#" name="CODE_LANGUAGE">
        <meta content="JavaScript" name="vs_defaultClientScript">
        <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    </HEAD>
        <script runat="server">

    public class DuplikatContext : ContextBase {
    
           public DuplikatContext(Context cx) : base(cx) {
           }
    
           bool duplikat = true;
    
           [Caption("Duplikat")]
           public bool Duplikat {
               get { return duplikat; }
               set { duplikat = value; }
           }
    
       }

    private class PozycjaWgCenyŚredniej : PozycjaWgCeny {
        private DoubleCy cenaNettoPoRabacie;
        private DoubleCy cenaBruttoPoRabacie;
        RodzajKorektyPozycji rodzajKorekty;
        public PozycjaWgCenyŚredniej(PozycjaDokHandlowego poz, int lp)
            : base(poz, lp) {
            this.cenaNettoPoRabacie = poz.CenaNettoPoRabacie;
            this.cenaBruttoPoRabacie = poz.CenaBruttoPoRabacie;
            if (poz.RodzajKorekty != RodzajKorektyPozycji.Brak)
                rodzajKorekty = poz.RodzajKorekty;
        }
        public void Dodaj(PozycjaDokHandlowego p) {
            base.Dodaj(p);
            if (!base.Ilosc.IsZero) {
                this.cenaNettoPoRabacie = new DoubleCy((double)base.WartoscCy.Value / base.Ilosc.Value, this.cenaNettoPoRabacie.Symbol);
                this.cenaNettoPoRabacie = this.cenaNettoPoRabacie.Round(2);
                this.cenaBruttoPoRabacie = new DoubleCy((double)(base.WartoscCy.Value + base.Stawka.VatOdNetto(base.WartoscCy.Value)) / base.Ilosc.Value, this.cenaBruttoPoRabacie.Symbol);
                this.cenaBruttoPoRabacie = this.cenaBruttoPoRabacie.Round(2);
            }
            if (p.RodzajKorekty != RodzajKorektyPozycji.Brak)
                rodzajKorekty = p.RodzajKorekty;
        }
        public override DoubleCy CenaNettoPoRabacie {
            get { return this.cenaNettoPoRabacie; }
        }
        public override DoubleCy CenaBruttoPoRabacie {
            get { return this.cenaBruttoPoRabacie; }
        }
        public new RodzajKorektyPozycji RodzajKorekty {
            get { return rodzajKorekty; }
        }
    }


    private IEnumerable PozycjeRazemWgTowaruICenyZKorektami(DokumentHandlowy dokument) {
        Hashtable ht = new Hashtable();
        Hashtable htK = new Hashtable();
        ArrayList arr = new ArrayList();
        ArrayList arrK = new ArrayList();
        int lp = 0;
        DokumentHandlowy korygowany = dokument.DokumentKorygowany;
        bool wszystkoPrzed = !dokument.Module.Config.Wydruki.TylkoRóżnicePrzedKorektą;
        bool wszystko = korygowany == null
            || !dokument.Module.Config.Wydruki.TylkoRóżniceNaKorekcie;
        if (korygowany != null) {
            foreach (PozycjaDokHandlowego poz in dokument.Pozycje) {
                PozycjaWgCeny.Klucz klucz = new PozycjaWgCeny.Klucz(poz.PozycjaKorygowana);
                PozycjaWgCenyŚredniej p = (PozycjaWgCenyŚredniej)ht[klucz];
                PozycjaWgCenyŚredniej pK = (PozycjaWgCenyŚredniej)htK[klucz];
                if (p == null || pK == null) {
                    lp++;
                    if (wszystko || poz.RodzajKorekty != RodzajKorektyPozycji.Brak)
                        ht[klucz] = p = new PozycjaWgCenyŚredniej(poz, lp);
                    if (wszystkoPrzed || poz.RodzajKorekty != RodzajKorektyPozycji.Brak)
                        htK[klucz] = pK = new PozycjaWgCenyŚredniej(poz.PozycjaKorygowana, lp);
                }
                else {
                    p.Dodaj(poz);
                    pK.Dodaj(poz.PozycjaKorygowana);
                }
            }
        }
        else {
            foreach (PozycjaDokHandlowego poz in dokument.Pozycje) {
                if (!wszystko && poz.RodzajKorekty == RodzajKorektyPozycji.Brak) continue;
                PozycjaWgCeny.Klucz klucz = new PozycjaWgCeny.Klucz(poz);
                PozycjaWgCeny p = (PozycjaWgCeny)ht[klucz];
                if (p == null) {
                    ht[klucz] = p = new PozycjaWgCeny(poz, ++lp);
                }
                else {
                    p.Dodaj(poz);
                }
            }
        }

        arrK.AddRange(htK.Values);
        arrK.Sort(PozycjaDokHandlowegoProxy.LpComparer);

        arr.AddRange(ht.Values);
        arr.Sort(PozycjaDokHandlowegoProxy.LpComparer);

        arrK.AddRange(arr);
        return arrK;
    }
  
    void OnContextLoading(Object sender, EventArgs args) {
        DokumentHandlowy d = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];
        if (d==null) return;
    
        if (d.Stan!=StanDokumentuHandlowego.Bufor) {
            if (!dc.Context.Contains(typeof(ParametryWydrukuDokumentu)))
                dc.AddRequiredType(typeof(DuplikatContext));
        }
    }
    
    bool duplikat = false;
    DokumentHandlowy dokument;

    private bool SprawdźPłatności( DokumentHandlowy dokument ) {
        bool result = false;
        foreach( Platnosc platnosc in dokument.Platnosci ) {
            if( platnosc.Kwota.Symbol.Equals( "PLN" ) ) {
                result = true;
            }
        }
        return result;
    }

   private bool SprawdźSwift( DokumentHandlowy dokument ) {
        bool warunek1 = dokument.DaneKontrahenta == null || dokument.RachunekBankowy == null || dokument.RachunekBankowy.Rachunek == null || dokument.RachunekBankowy.Rachunek.SWIFT == "";
        bool warunek2 = false;
        if( dokument.Kontrahent != null && dokument.Kontrahent.RodzajPodmiotu == RodzajPodmiotu.Krajowy ) 
            warunek2 = dokument.RachunekBankowy != null && dokument.RachunekBankowy.Waluta.Symbol.Equals( "PLN" ) && SprawdźPłatności( dokument );   

        return ( warunek1 || warunek2 );
    }

    private bool SprawdźSwift2( DokumentHandlowy dokument ) {
        bool warunek1 = dokument.DaneKontrahenta == null || dokument.RachunekBankowy2 == null || dokument.RachunekBankowy2.Rachunek == null || dokument.RachunekBankowy2.Rachunek.SWIFT == "";
        bool warunek2 = false;
        if( !warunek1 && dokument.Kontrahent != null && dokument.Kontrahent.RodzajPodmiotu == RodzajPodmiotu.Krajowy ) 
            warunek2 = dokument.RachunekBankowy2 != null && dokument.RachunekBankowy2.Waluta.Symbol.Equals( "PLN" ) && SprawdźPłatności( dokument );   

        return ( warunek1 && warunek2 );
    }     	            
    
    void OnContextLoad(Object sender, EventArgs args) {
        //
        // Inicjacja pól
        //
        if (dc.Context.Contains(typeof(DuplikatContext)))
            duplikat = ((DuplikatContext)dc[typeof(DuplikatContext)]).Duplikat;

        dokument = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];
        ObcyKorygowany.Visible = dokument.DokumentyKorygowanePierwsze.Any(x => !string.IsNullOrEmpty(x.Obcy.Numer));
        NipSection.Visible = dokument.DaneKontrahenta.StatusPodmiotu != StatusPodmiotu.Finalny || !String.IsNullOrEmpty( dokument.DaneKontrahenta.EuVAT );
        
        IPieczątkaFirmy pieczątka = ReportHeader.GetPieczątka( dc, null, false );
        NazwaFirmy.EditValue = pieczątka.NazwaFormatowana;
        AdresLinia1.EditValue = pieczątka.Adres.Linia1;
        AdresLinia2.EditValue = pieczątka.Adres.Linia2;
        var BDO = pieczątka.BDO;
        BDOFirmyS.EditValue = "BDO: " + BDO;

            if(String.IsNullOrWhiteSpace(BDO))
            BDOFirmyS.Visible = false;

        if( dokument.Kontrahent.RodzajPodmiotu != RodzajPodmiotu.Krajowy )
            NipFirmy.EditValue = pieczątka.EuVAT.Replace("-", String.Empty);
        else
            NipFirmy.EditValue = pieczątka.NIP;

        colSWW.Visible = dokument.JestSWW;

        if (dokument.RachunekBankowy==null
            || dokument.RachunekBankowy.Rachunek == null
            || dokument.RachunekBankowy.Rachunek.Bank==null)
            labelBank.Visible = false;

        if( !dokument.Definicja.DrukujSWIFTZawsze ) {
            if( SprawdźSwift( dokument ) )
                labelSwift.Visible = false;
        }

        if (dokument.RachunekBankowy2 == null
            || dokument.RachunekBankowy2.Rachunek == null
            || dokument.RachunekBankowy2.Rachunek.Bank == null)
            labelBank2.Visible = false;

        if( SprawdźSwift2( dokument ) )
            labelSwift2.Visible = false;
    
        if (dokument.OdBrutto)
            colWartosc.Caption = "Wartość brutto";
        else
            colWartosc.Caption = "Wartość netto";
        
        colRodzajKorekty.Visible = dokument.DokumentKorygowany != null;
        colPlatnik.Visible = dokument.InnyPłatnik;
        labelOperator.EditValue = dokument.Wydruk.UprawnionyDoWystawienia.FullName;
        labelCopyright.EditValue = dc.Copyright;
        sectionVAT.Visible = dokument.Definicja.SumyVAT != SposobLiczeniaSumVAT.NieLiczyć;

        if (dokument.Wydruk.NabywcaPodatnik == 1)
            sectionVAT.Visible = false;
        
        TextGrid1.DataSource = this.PozycjeRazemWgTowaruICenyZKorektami(dokument);

        // Ukrywanie ceny netto/brutto zależnie od typu dokumentu
        Grid1_CenaNettoPoRabacie.Visible = !dokument.OdBrutto;
        Grid1_CenaBruttoPoRabacie.Visible = dokument.OdBrutto;
        
        if (dokument.ID < 0 || dokument.State == RowState.Modified)
            DataLabelOstrzezenie.EditValue = "Zmiany na dokumencie nie zostały zatwierdzone";

        if( dokument.Wydruk.JestPłatnośćWielePrzelewów )
                SposobZaplaty.Width = 38;
    }
    
            void gridNiezaplacone_BeforeRow(object sender, RowEventArgs args) {
                WydrukDokumentu.NiezapłaconeInfo pl = (WydrukDokumentu.NiezapłaconeInfo)
                    args.Row;

                // Mateusz - task 10271
                if( pl.Płatność.SposobZaplaty.Typ != TypySposobowZaplaty.Przelew 
                    || ( pl.Płatność.SposobZaplaty.Typ == TypySposobowZaplaty.Przelew && pl.Płatność.EwidencjaSP.Rachunek.Numer == (pl.Płatność.Dokument as DokumentHandlowy).RachunekBankowy.Rachunek.Numer 
                    && (pl.Płatność.Dokument as DokumentHandlowy).Wydruk.Niezapłacone.Count == 1 ) ) { // dla całej reszty zostawiamy jak leci
                    SposobZaplaty.EditValue = pl.Płatność.SposobZaplaty;
                }
                else  { // a dla przelewu doklejamy numer rachunku
                    SposobZaplaty.AddLine( pl.Płatność.SposobZaplaty + " na rachunek bankowy" );
                    SposobZaplaty.AddLine( pl.Płatność.EwidencjaSP.Rachunek.Numer );
                }


                colPlatnik.EditValue = pl.Płatność.Podmiot.Nazwa + '\n' +
                                       pl.Płatność.Podmiot.Adres + "\nNIP: " +
                                       pl.Płatność.Podmiot.EuVAT;
            }
            void gridZaliczki_BeforeRow(object sender, RowEventArgs args)
            {
                DokumentHandlowy z = (DokumentHandlowy)args.Row;
                DokumentHandlowy d = (DokumentHandlowy)this.dc.Context[typeof(DokumentHandlowy)];
                SubTable st = d.ZaliczkiRelacje;
                if (st.IsEmpty
                    && z.SposobPrzenoszeniaZaliczki == SposobPrzenoszeniaZaliczki.NieDotyczy)
                {
                    this.colZaliczka.EditValue = z.BruttoCy;
                }
                else
                {
                    Currency v = new Currency(decimal.Zero, z.BruttoCy.Symbol);
                    foreach (RelacjaHandlowa.Zaliczka rz in st)
                    {
                        if (rz.Nadrzedny == z)
                        {
                            v += rz.Wartosc;
                        }
                    }
                    this.colZaliczka.EditValue = v;
                }
            }	
        </script>
    <body>
        <font face="Courier New" size="smaller">
            <form id="Sprzedaż" method="post" runat="server">
                <ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" oncontextloading="OnContextLoading"
                    oncontextload="OnContextLoad"></ea:datacontext><ea:datalabel id="DataLabel1" runat="server" DataMember="Definicja.TytulWydruku"></ea:datalabel><ea:datalabel id="DataLabel2" runat="server" DataMember="Session.Handel.Config.Ogólne.MałyPodatnik">
                    <ValuesMap>
                        <ea:ValuesPair Key="False" Value="" />
                        <ea:ValuesPair Key="True" Value=" MP" />
                    </ValuesMap>
                </ea:datalabel>&nbsp;<b><ea:datalabel id="DataLabel3" runat="server" DataMember="Numer"></ea:datalabel>
                    <% if (duplikat) { %>
                    DUPLIKAT
                    <% } %>
                </b>
                <ea:DataLabel runat="server" DataMember="Stan" id="DataLabel4">
                    <ValuesMap>
                        <ea:ValuesPair Key="Anulowany" Value="&lt;br&gt;Dokument został anulowany"></ea:ValuesPair>
                        <ea:ValuesPair Key="Bufor" Value="&lt;br&gt;Dokument nie został zatwierdzony"></ea:ValuesPair>
                        <ea:ValuesPair Key="Zablokowany" Value=""></ea:ValuesPair>
                        <ea:ValuesPair Key="Zatwierdzony" Value=""></ea:ValuesPair>
                    </ValuesMap>
                </ea:DataLabel>
                <br>
                <ea:DataLabel ID="DataLabelOstrzezenie" runat="server"></ea:DataLabel>
                <br/>
                &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Definicja.NazwaDatyEtykieta" NonBreakSpace="True" id="Datalabel5x"
                        WidthChars="35" Align="Left"></ea:datalabel></i>
                <ea:datalabel id="DataLabel5" runat="server" DataMember="Data"></ea:datalabel><br>
                &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Definicja.NazwaDatyOperacjiEtykieta" NonBreakSpace="True"
                        id="Datalabel6" WidthChars="35" Align="Left"></ea:datalabel></i>
                <ea:datalabel id="DataLabel6x" runat="server" DataMember="DataOperacji"></ea:datalabel><br>
                <% if (duplikat) { %>
                &nbsp;&nbsp;&nbsp;&nbsp;<i>Data wystawienia 
                    duplikatu:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i>
                <%= Date.Today%>
                <br>
                <% } %>
                <ea:Section ID="Section1" Runat="server" DataMember="DokumentKorygowany" ConditionValue="IS NOT NULL" Width="100%">
            <i>Dokument korygowany:----------------------------------------------------------</i><br>
            <ea:datarepeater runat="server" rowtypename="Soneta.Handel.DokumentHandlowy,Soneta.Handel" DataMember="DokumentyKorygowanePierwsze">
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel runat="server" DataMember="Numer"></ea:datalabel>

                <ea:Section  ID="ObcyKorygowany" runat="server" EncodeHTML="True">
                                            <br />
                                            <span style="font-weight: normal; font-size: 13px;" >
                                                Dokument obcy nr:                                          
                                            <ea:DataLabel runat="server" DataMember="Obcy.Numer" EncodeHTML="True">
                                            </ea:DataLabel>
                                            </span>
                                        </ea:Section>

                <br/>
                &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataEtykieta" NonBreakSpace="True" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.Data"></ea:datalabel>
                <br/>
                &nbsp;&nbsp;&nbsp;&nbsp;<i><ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacjiEtykieta" NonBreakSpace="True" WidthChars="35" Align="Left"></ea:datalabel></i>
            <ea:datalabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacji"></ea:datalabel>
                <br />
            </ea:DataRepeater>
            </ea:Section>
                <i>Sprzedawca:-------------------------------------------------------------------</i><br>
                <ea:datalabel id="NazwaFirmy" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
                <ea:datalabel id="AdresLinia1" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
                <ea:datalabel id="AdresLinia2" runat="server" LeftMargin="4" EncodeHTML="True"></ea:datalabel><br>
                &nbsp;&nbsp;&nbsp;&nbsp;NIP:
                <ea:datalabel id="NipFirmy" runat="server"></ea:datalabel><br>
                <ea:dataLabel id="BDOFirmyS" runat="server" Bold="False" EncodeHTML="True"></ea:datalabel><br>
                        
            <!-- Oddział firmy -->
            <ea:Section ID="OddzialFirmy" runat="server" DataMember="Wydruk.JestOddzial">
                <em style="text-decoration: none;">Oddział:</em><br />
                <ea:DataLabel ID="DataLabel42" runat="server" EncodeHTML="True" DataMember="Wydruk.Oddział.Nazwa" LeftMargin="4" ></ea:DataLabel><br />
                <ea:DataLabel ID="DataLabel44" runat="server" EncodeHTML="True" Bold="false" DataMember="Wydruk.Oddział.Adres.Linia1" LeftMargin="4" ></ea:DataLabel><br />
                <ea:DataLabel ID="DataLabel45" runat="server" EncodeHTML="True" Bold="false" DataMember="Wydruk.Oddział.Adres.Linia2" LeftMargin="4" ></ea:DataLabel><br />
            </ea:Section>
            <!-- Oddział firmy -->                        

                <i>Konto bankowe:</i><br>
                <ea:DataLabel id="labelBank" runat="server" DataMember="RachunekBankowy.Rachunek.Bank.Nazwa" Bold="False"
                    Format="{0}<br>" LeftMargin="4"></ea:DataLabel><ea:DataLabel id="labelSwift" runat="server" DataMember="RachunekBankowy.Rachunek.SWIFT" Bold="False"
                    Format="SWIFT: {0}<br>" LeftMargin="4"></ea:DataLabel><ea:datalabel id="DataLabel13" runat="server" DataMember="RachunekBankowy.Rachunek.Numer" LeftMargin="4"></ea:datalabel><br>
                <ea:Section id="DrugiRachunekSection" runat="server" DataMember="IsRachunekBankowy2">
                <i>Drugie konto bankowe:</i><br>
                <ea:DataLabel id="labelBank2" runat="server" DataMember="RachunekBankowy2.Rachunek.Bank.Nazwa" Bold="False"
                    Format="{0}<br>" LeftMargin="4"></ea:DataLabel><ea:DataLabel id="labelSwift2" runat="server" DataMember="RachunekBankowy2.Rachunek.SWIFT" Bold="False"
                    Format="SWIFT: {0}<br>" LeftMargin="4"></ea:DataLabel><ea:datalabel id="DataLabel41" runat="server" DataMember="RachunekBankowy2.Rachunek.Numer" LeftMargin="4"></ea:datalabel><br>
                </ea:Section>
                <i>Nabywca:----------------------------------------------------------------------</i><br>
                <ea:datalabel id="DataLabel14" runat="server" DataMember="DaneKontrahenta.NazwaFormatowana" LeftMargin="4"
                    EncodeHTML="True"></ea:datalabel><br>
                <ea:datalabel id="DataLabel15" runat="server" DataMember="DaneKontrahenta.Adres.Linia1" EncodeHTML="True"
                    LeftMargin="4"></ea:datalabel><br>
                <ea:datalabel id="DataLabel16" runat="server" DataMember="DaneKontrahenta.Adres.Linia2" EncodeHTML="True"
                    LeftMargin="4"></ea:datalabel><br>
          <ea:Section ID="NipSection" runat="server" >
                  &nbsp;&nbsp;&nbsp;&nbsp;NIP:
                    <ea:datalabel id="DataLabel17" runat="server" DataMember="DaneKontrahenta.EuVAT"></ea:datalabel>
          </ea:Section>
            <br>
                <ea:Section ID="Section2" Runat="server" DataMember="Wydruk.JestOdbiorca" Width="100%">
            <i>Odbiorca:---------------------------------------------------------------------</i><br>
            <ea:datalabel id="DataLabel18" runat="server" DataMember="DaneOdbiorcy.NazwaFormatowana" EncodeHTML="True"
                        LeftMargin="4"></ea:datalabel><br>
            <ea:datalabel id="DataLabel19" runat="server" DataMember="DaneOdbiorcy.Adres.Linia1" EncodeHTML="True"
                        LeftMargin="4"></ea:datalabel><br>
            <ea:datalabel id="DataLabel20" runat="server" DataMember="DaneOdbiorcy.Adres.Linia2" EncodeHTML="True"
                        LeftMargin="4"></ea:datalabel><br>
            &nbsp;&nbsp;&nbsp;&nbsp;NIP:
            <ea:datalabel id="DataLabel21" runat="server" DataMember="DaneOdbiorcy.EuVAT"></ea:datalabel><br>
            </ea:Section>
                <small>
                    <ea:Section id="KursSection" runat="server" DataMember="Wydruk.JestWaluta" Width="100%">
                        <FONT size="2">Kurs <STRONG>1 </STRONG>
                            <ea:DataLabel id="DataLabel31" runat="server" DataMember="BruttoCy.Symbol"></ea:DataLabel>&nbsp;=
                            <ea:DataLabel id="KursWaluty" runat="server" DataMember="KursWaluty"></ea:DataLabel><STRONG>&nbsp;PLN</STRONG>
                            z dnia
                            <ea:DataLabel id="DataLabel32" runat="server" DataMember="DataOgłoszeniaKursu"></ea:DataLabel>&nbsp; 
                            (
                            <ea:DataLabel id="DataLabel33" runat="server" DataMember="TabelaKursowa"></ea:DataLabel>)</FONT></ea:Section>
                    <ea:TextGrid runat="server" id="TextGrid1" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                        GroupData0="Workers.WydrukPozycji.SekcjaDokumentu" GroupLine="{0}">
                        <Columns>
                            <ea:GridColumn Width="3" Align="Right" DataMember="Lp" Caption="Lp." Runat="server"></ea:GridColumn>
                            <ea:GridColumn DataMember="PełnaNazwa" Caption="Nazwa towaru/usługi" EncodeHTML="True" Runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="7" RightBorder="None" Align="Right" DataMember="Ilosc.Value" Caption="Ilość"
                                Runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="4" DataMember="Ilosc.Symbol" Caption="jm." Runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="Grid1_CenaNettoPoRabacie" Width="15" Align="Right" DataMember="CenaNettoPoRabacie" Caption="Cena netto" Runat="server"></ea:GridColumn>
                            <ea:GridColumn ID="Grid1_CenaBruttoPoRabacie" Width="15" Align="Right" DataMember="CenaBruttoPoRabacie" Caption="Cena brutto"
                                Runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="16" Align="Right" DataMember="WartoscCy" Caption="Wartość" Runat="server"
                                ID="colWartosc"></ea:GridColumn>
                            <ea:GridColumn Width="6" Align="Center" DataMember="DefinicjaStawki" Caption="St.VAT" Runat="server"></ea:GridColumn>
                            <ea:GridColumn Width="15" DataMember="SWW" Caption="PKWiU" Runat="server" ID="colSWW"></ea:GridColumn>
                            <ea:GridColumn Runat="server" ID="colRodzajKorekty" Caption="Zmiana" DataMember="RodzajKorektyOpis"
                                Width="16"></ea:GridColumn>
                        </Columns>
                    </ea:TextGrid>
                </small>
                <ea:Section ID="sectionVAT" Runat="server" Pagination="True">
                    <small>
                        <ea:TextGrid runat="server" id="TextGrid2" DataMember="SumyVAT" RowTypeName="Soneta.Handel.SumaVAT,Soneta.Handel"
                            ShowFirstLine="False" LeftMargin="57">
                            <Columns>
                                <ea:GridColumn Width="14" Align="Center" DataMember="DefinicjaStawki" Total="Info" Caption="Stawka VAT"
                                    Runat="server"></ea:GridColumn>
                                <ea:GridColumn Width="18" Align="Right" DataMember="Suma.NettoCy" Total="Sum" Caption="Kwota netto"
                                    Runat="server"></ea:GridColumn>
                                <ea:GridColumn Width="18" Align="Right" DataMember="Suma.VATCy" Total="Sum" Caption="Kwota VAT"
                                    Runat="server"></ea:GridColumn>
                                <ea:GridColumn Width="18" Align="Right" DataMember="Suma.BruttoCy" Total="Sum" Caption="Kwota brutto"
                                    Runat="server"></ea:GridColumn>
                            </Columns>
                        </ea:TextGrid>
                    </small>
                </ea:Section>
                <ea:Section ID="section3" Runat="server" DataMember="Wydruk.JestSumaPozycji" Pagination="True" WidthChars="80">
            <i>Suma brutto dokumentu:</i>
            <ea:datalabel ID="labelSumaPozycji" DataMember="SumaPozycji.Brutto" runat="server"></ea:datalabel>PLN</ea:Section>
                <ea:Section ID="section4" Runat="server" DataMember="Wydruk.DokumentyZaliczkowe" Pagination="True" WidthChars="80">
                    <pre><i>Faktury zaliczkowe:</i></pre>
                    <small>
                        <ea:TextGrid id="gridZaliczkowe" runat="Server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
                            DataMember="DokumentyZaliczkowe" OnBeforeRow="gridZaliczki_BeforeRow">
                            <Columns>
                                <ea:GridColumn Runat="server" Caption="Lp." DataMember="#" Align="Right" Width="3"></ea:GridColumn>
                                <ea:GridColumn Runat="server" DataMember="Numer" Width="36"></ea:GridColumn>
                                <ea:GridColumn Runat="server" Total="Info" DataMember="Data" Width="12"></ea:GridColumn>
                                <ea:GridColumn Runat="server" Total="Sum" DataMember="BruttoCy" Align="Right" Width="18"></ea:GridColumn>
                                <ea:GridColumn runat="server" Width="18" Align="Right" Total="Sum" ID="colZaliczka"
                                    Caption="Rozliczona zaliczka"></ea:GridColumn>
                            </Columns>
                        </ea:TextGrid>
                    </small>
                </ea:Section>
                <ea:KeepLines ID="Keep1" runat="server" NumberLines="4" WidthChars="80">
                </ea:KeepLines>
                <br>
                <i>
                    <ea:datalabel id="DataLabel22" runat="server" DataMember="Wydruk.KierunekZapłaty" NonBreakSpace="True"
                        Format="{0}:" WidthChars="21" Align="Right"></ea:datalabel></i>&nbsp;<b><ea:datalabel id="DataLabel23" runat="server" DataMember="Wydruk.BruttoCyPlus"></ea:datalabel></b><br>
                <i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Słownie:</i>
                <small>
                    <ea:datalabel id="DataLabel24" runat="server" DataMember="BruttoCy" Format="{0:+t}"></ea:datalabel></small><br>
                <ea:Section ID="section5" Runat="server" DataMember="Zaliczki" Pagination="True" WidthChars="80">
                    <pre><i>Rozliczone zaliczki:</i></pre>
                    <small>
                        <ea:TextGrid ID="gridZaplaty" Runat="server" DataMember="Zaliczki" RowTypeName="Soneta.Handel.RelacjaZaliczki,Soneta.Handel">
                            <Columns>
                                <ea:GridColumn Runat="server" Caption="Lp." DataMember="#" Align="Right" Width="3"></ea:GridColumn>
                                <ea:GridColumn Runat="server" Caption="Spos&#243;b zapłaty" DataMember="Zaplata.SposobZaplaty"
                                    Align="Center" Width="16"></ea:GridColumn>
                                <ea:GridColumn Runat="server" Caption="Data zapłaty" DataMember="Zaplata.DataDokumentu" Align="Center"
                                    Width="12"></ea:GridColumn>
                                <ea:GridColumn Runat="server" DataMember="Kwota" Align="Right" Width="16"></ea:GridColumn>
                                <ea:GridColumn Runat="server" Caption="Numer dokumentu" DataMember="Zaplata.NumerDokumentu" Width="26"></ea:GridColumn>
                            </Columns>
                        </ea:TextGrid>
                    </small>
                </ea:Section>
                <ea:Section ID="section6" Runat="server" DataMember="Wydruk.ZapłataCzęściowa" Pagination="True" WidthChars="80">
            <br>
            <ea:datalabel runat="server" DataMember="Wydruk.Zapłacono" id="Datalabel25"></ea:datalabel>
            <ea:datalabel runat="server" DataMember="Zapłata.SposobZaplaty.Biernik" id="Datalabel26"></ea:datalabel>
            : <b>
                        <ea:datalabel runat="server" DataMember="Zapłata.SłownieUpr" id="Datalabel27"></ea:datalabel></b><br>
            </ea:Section>
                <ea:Section ID="section7" Runat="server" DataMember="Wydruk.ZapłataCałkowita" Pagination="True" WidthChars="80">
                    <br>
                    <ea:datalabel runat="server" DataMember="Wydruk.Zapłacono" id="Datalabel28"></ea:datalabel>
                    <ea:datalabel runat="server" DataMember="Zapłata.SposobZaplaty.Biernik" id="Datalabel29"></ea:datalabel>
                    <br>
                </ea:Section>
                <ea:Section ID="section8" Runat="server" DataMember="Wydruk.SąNiezapłacone" Pagination="True" WidthChars="80">
                    <br>
                    <i>Pozostało do zapłaty:</i>
                    <br />
                    <small>
                        <ea:TextGrid ID="gridNiezaplacone" Runat="server" DataMember="Wydruk.Niezapłacone" RowTypeName="Soneta.Handel.WydrukDokumentu+NiezapłaconeInfo,Soneta.Handel"
                            OnBeforeRow="gridNiezaplacone_BeforeRow">
                            <Columns>
                                <ea:GridColumn Runat="server" Caption="Lp." DataMember="#" Align="Right" Width="3"></ea:GridColumn>
                                <ea:GridColumn Runat="server" Caption="Spos&#243;b zapłaty" ID="SposobZaplaty"
                                    Align="Center" Width="16"></ea:GridColumn>
                                <ea:GridColumn Runat="server" Caption="Termin" DataMember="Płatność.Termin" Align="Center" Width="12"></ea:GridColumn>
                                <ea:GridColumn Runat="server" DataMember="Kwota" Align="Right" Width="16"></ea:GridColumn>
                                <ea:GridColumn Runat="server" ID="colPlatnik" Caption="Płatnik" Width="46" EncodeHTML="True"></ea:GridColumn>
                            </Columns>
                        </ea:TextGrid>
                    </small>
                </ea:Section>
                <ea:KeepLines ID="Keep2" runat="server" NumberLines="8" WidthChars="80">
                </ea:KeepLines>
                <ea:Section ID="sectionNumeryNadrzednych" runat="server" DataMember="Wydruk.CzyDrukowacNumeryPowiazanych" Pagination="True" WidthChar="80">
                    <em>Dokumenty powiązane:</em>
                    <div>
                        <ea:DataLabel ID="labelNumeryNadrzednych" runat="server" DataMember="Wydruk.NumeryNadrzędneZK" Bold="False" WidthChar="60"></ea:DataLabel>
                        <ea:DataLabel ID="labelNumeryPodrzednych" runat="server" DataMember="Wydruk.NumeryPodrzędneBK" Bold="False" WidthChar="60"></ea:DataLabel>
                    </div>
                </ea:Section>
                <p><ea:DataLabel ID="labelOpis" runat="server" DataMember="Opis" Bold="False"></ea:DataLabel></p>
                <p><ea:DataLabel ID="labelOpisWydruku" runat="server" DataMember="Wydruk.OpisWydruku" Bold="False"></ea:DataLabel>&nbsp;</p>
                ---------------------------------------+---------------------------------------<br />
                <ea:DataLabel ID="labelOperator" Runat="server" Align="Center" WidthChars="40" Bold="False"></ea:DataLabel>|<ea:DataLabel ID="DataLabel37" Runat="server" DataMember="Osoba" Align="Center" WidthChars="39"
                    Bold="False"></ea:DataLabel><br />
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|<br />
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|<br />
                &nbsp;&nbsp;&nbsp;&nbsp; ................................&nbsp;&nbsp;&nbsp; | 
                ...............................<br />
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Podpis osoby 
                upoważnionej&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                |&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Podpis osoby upoważnionej<br />
                <ea:DataLabel ID="DataLabel38" Runat="server" DataMember="Wydruk.NazwaDokumentu" Align="Center"
                    WidthChars="40" Format="do wystawienia {0}" Bold="False"></ea:DataLabel>|<ea:DataLabel ID="DataLabel34" Runat="server" DataMember="Wydruk.NazwaDokumentu" Align="Center"
                    WidthChars="39" Format="do otrzymania {0}" Bold="False"></ea:DataLabel>
                <br />
                <small>
                <!--
                    <ea:DataLabel id="labelCopyright" runat="server" Bold="False" Align="Right" WidthChars="130"></ea:DataLabel>
                -->
                </small>
                <cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                </cc1:ReportFooter>
                <ea:PageBreak id="PageBreak1" runat="server"></ea:PageBreak>
            </form>
        </font>
    </body>
</HTML>

